setwd("---")

library(tidyverse)
library(viridis)
library(patchwork)
library(hrbrthemes)
library(ggraph)
library(igraph)
library(networkD3)
library(colormap)
library(tibble)
library(dplyr)

pulm_ade_df <- read.csv(file = 'pulm_meddra_hypts.csv', header=T, sep="$")
pulm_ade <- toupper(unique(pulm_ade_df$hlt))
pulm_ade <- pulm_ade[-c(1, 8,17,18,26)]
pulm_ade <- sort(pulm_ade)

adj.mat <- read.csv('hypt_cuthill_22.csv', sep = ',', header = T)
row.names(adj.mat) <- adj.mat$X
adj.mat <- adj.mat[, -1]
select_drugs <- gsub(".*\\.","",colnames(adj.mat))

pulm_df_1 <- read.csv(file="hypts_pulm_EBGM_hlt.csv", header=T, sep="$")
head(pulm_df_1)

pulm_df <- pulm_df_1 %>%
            filter(var1 %in% select_drugs) %>% 
            filter(QUANT_05 > 1) %>%  
            arrange(var1)

pulm_df_EBGM <- pulm_df %>%
                  filter(var2 %in% pulm_ade) %>%
                    ### adding filter rule of QUANT05 > 1
                    filter(QUANT_05 > 1) %>%
                      select(var1, var2, ebgm) %>%
                        spread(var1, ebgm) %>%
                          replace(is.na(.), 0) %>%
                            column_to_rownames(var = 'var2') %>%
                as.data.frame()

pulm_df_EBGM_1 <- pulm_df_EBGM %>%
                    mutate_if(is.factor, as.numeric) %>%
                      mutate_all(~ if_else(.x <= 1, 0,.x)) %>%
                        as.data.frame()

rownames(pulm_df_EBGM_1) <- rownames(pulm_df_EBGM)
pulm_df_EBGM_1[1:5, 1:5]
dim(pulm_df_EBGM_1)
t(pulm_df_EBGM_1)

### put column pt and soc togeter
hlt_soc_dict <- read.csv(file="hpyts_hlt_soc_dict.csv", header=T, sep="$")
hlt_soc_dict <- as.data.frame(hlt_soc_dict)[,2:3]
hlt_soc_dict <- mutate_all(hlt_soc_dict, funs(toupper))
hlt_list <- as.data.frame(rownames(pulm_df_EBGM_1))
colnames(hlt_list) <- 'hlt'

hlt_soc_list <- left_join(hlt_list, hlt_soc_dict)
lowernodenames = paste(gsub("","",hlt_soc_list$soc_abr), hlt_soc_list$hlt, sep=".")

rownames(pulm_df_EBGM_1) <- hlt_soc_list$hlt
colnames(pulm_df_EBGM_1) <- colnames(adj.mat)

##############
### hlt tables

p_df_hlt <- pulm_df %>%
            filter(var2 %in% pulm_ade) %>%
            filter(QUANT_05 > 1) %>%
            select(var1, var2, ebgm) %>%
            # get drugs with pulm ade frequency larger than 1
            group_by(var1) %>% 
            filter(n()>1 )

hlt_order <- pulm_df %>%
              filter(var2 %in% pulm_ade) %>%
              select(var1, var2) %>%
              # get drugs with pulm ade frequency larger than 1
              group_by(var2) %>% 
              summarise(n = n()) %>%
              arrange(-n) 

for (i in unique(p_df_hlt$var1)){
  ade_drug <- p_df_hlt %>%
    filter(var1 == i) 
  print(i)
  intersection_pulm <- intersect(hlt_order$var2, unique(ade_drug$var2))
  index_match <- match(intersection_pulm, hlt_order$var2)
  print(index_match)
  print(length(index_match))
}
##############
### Combine drug*drug matrix, drug*ade matrix
pulm_df_EBGM_binary <- pulm_df_EBGM_1 %>%
                          mutate_if(is.numeric, ~ (. >= 1) * 1)
rownames(pulm_df_EBGM_binary) <- rownames(pulm_df_EBGM_1)
pulm_df_EBGM_binary = pulm_df_EBGM_binary[rowSums(pulm_df_EBGM_binary)>0,]
dim(pulm_df_EBGM_binary)
ade_num <- dim(pulm_df_EBGM_binary)[1]

right_v <- as.matrix(t(pulm_df_EBGM_binary))

right_top <- matrix(0, 22, 374)

for (i in 1:22){
  right_top[i, (17*(i-1)+1):(17*(i))] <- right_v[i,]
}

col_ade_name <- rep(rownames(pulm_df_EBGM_binary),22)
col_ade_num <- as.character(rep(1:22, each=17))
right_top_col <- as.data.frame(cbind(col_ade_name, col_ade_num))
colnames(right_top) <- paste(right_top_col$col_ade_name, right_top_col$col_ade_num)

right_top <- right_top[,colSums(right_top)>0]
ade_num <- dim(right_top)[2]
colnames(right_top)

### heatmap of top right
my_palette <- colorRampPalette(c("corn flower blue", "white"))(n = 2)
heatmap.2(as.matrix(right_top), dendrogram='none', Rowv=FALSE, Colv=FALSE, trace='none', col = my_palette)

up.mat <- cbind(adj.mat, right_top)
bm_zero <- cbind(t(right_top), matrix(0, ade_num, ade_num))
colnames(bm_zero)<-colnames(up.mat)
quad.mat <- as.matrix(rbind(up.mat, bm_zero))
colnames(quad.mat) <- rownames(quad.mat)

# write.table(quad.mat, "block_matrix_quant05.csv", sep = "$")

col.order <- c(106,105,18,25,24,1,23,63,62,33,32,10,5,79,78,77,138,137,29,28,13,22,3,27,2,26,99,98,65,64,16,11,31,4,30,97,96,95
               ,94,93,92,91,90,89,88,87,86,85,84,83,82,57,56,55,54,53,52,51,50,49,48,47,46,45,44,76,75,74,73,72,71,70,69,68,67,66
               ,126,125,124,123,122,121,120,119,118,117,116,115,114,113,112,111,110,109,108,107,15,8,12,20,19,136,135,134,133,132,
               131,130,129,128,127,21,40,39,38,37,36,35,6,34,81,80,14,43,42,7,41,104,103,102,101,100,17,61,60,59,9,58)
# dff <- read.csv("block_matrix_quant05.csv", sep = '$')
dff <- quad.mat

all_nodes <- colnames(dff)
drug_nodes <- all_nodes[1:22]

dataUU <- dff
dataUU <- dataUU[col.order, col.order]
dataUU$from <- colnames(dataUU)

connect <- dataUU %>% 
            gather(key="to", value="value", 1:138) %>%
              na.omit() 
connect <- connect[connect$value != 0,]

# Number of connection per person
c(as.character(connect$from), as.character(connect$to)) %>%
  as.tibble() %>%
  group_by(value) %>%
  summarize(n=n()) -> coauth
colnames(coauth) <- c("name", "n")

# assign col m indicating size
coauth <- coauth %>%
  mutate(m = if_else(name%in%drug_nodes, 3, 2))

# Create a graph object with igraph
mygraph <- graph_from_data_frame(connect, vertices = coauth, directed = TRUE )

# Find community
com <- walktrap.community(mygraph)
#max(com$membership)

#Reorder dataset and make the graph
coauth <- coauth %>% 
            mutate( grp = com$membership) %>%
              arrange(-grp) %>%
                mutate(name=factor(name, name))

### Reordering
coauth <- coauth %>% 
            arrange(match(name, drug_ade_order))

# Create a graph object with igraph
mygraph <- graph_from_data_frame(connect, vertices = coauth, directed = FALSE )

# prepare a vector of n color in the viridis scale
mycolor <- colormap(colormap=colormaps$jet, nshades=max(coauth$grp))
mycolor <- sample(mycolor, length(mycolor))

# Make the graph
gg <-ggraph(mygraph, layout="linear") + 
  geom_edge_arc() +
  geom_node_point(aes(size=m, color=as.factor(grp), fill=grp), alpha=0.9) +
  scale_size_continuous(range=c(5,10)) +
  scale_color_manual(values=mycolor) +
  geom_node_text(aes(label=name), angle=90, hjust=1, nudge_y = -1.1, size=4.5) +
  theme_void() +
  theme(
    legend.position="none",
    plot.margin=unit(c(0,0,0.10,0), "null"),
    panel.spacing=unit(c(0,0,4.5,0), "null")
  ) +
  expand_limits(x = c(-1.2, 1.2), y = c(-30.6, 1.2)) 

gg

ggsave(
  "./arcdiagram_drug_hlt.pdf",
  width = 40,
  height = 20,
  scale = 1.1
)